/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Code;
import jp.ac.kobe_u.cs.cream.Condition;
import jp.ac.kobe_u.cs.cream.LocalSearch;
import jp.ac.kobe_u.cs.cream.Network;

public class IBBSearch
extends LocalSearch {
    private double clearRate = 0.8;

    public IBBSearch(Network network) {
        this(network, -1, null);
    }

    public IBBSearch(Network network, int n) {
        this(network, n, null);
    }

    public IBBSearch(Network network, String string) {
        this(network, -1, string);
    }

    public IBBSearch(Network network, int n, String string) {
        super(network, n, string);
        this.setExchangeRate(0.8);
    }

    public double getClearRate() {
        return this.clearRate;
    }

    public void setClearRate(double d) {
        this.clearRate = d;
    }

    private void bbSearch(long l) {
        if (this.isAborted()) {
            return;
        }
        this.solver.start(l);
        while (this.solver.waitNext()) {
            this.solution = this.solver.getSolution();
            this.success();
            if (this.isAborted()) break;
            this.solver.resume();
        }
        this.solver.stop();
        this.solution = this.solver.getBestSolution();
    }

    @Override
    public void startSearch() {
        this.bbSearch(this.initialTimeout);
    }

    @Override
    public void nextSearch() {
        if (this.isAborted()) {
            return;
        }
        this.solution = this.getCandidate();
        if (this.solution == null) {
            return;
        }
        Code code = this.solution.getCode();
        code = (Code)code.clone();
        Condition[] conditionArray = code.conditions;
        for (int i = 0; i < conditionArray.length; ++i) {
            if (!(Math.random() < this.clearRate)) continue;
            conditionArray[i] = null;
        }
        code.setTo(this.network);
        this.bbSearch(this.iterationTimeout);
    }
}

