/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.IntVariable;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class IntArith
extends Constraint {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int MAX = 6;
    public static final int MIN = 7;
    private int operation;
    private Variable[] v;

    public IntArith(Network network, int n, Variable variable, Variable variable2, Variable variable3) {
        this(network, n, new Variable[]{variable, variable2, variable3});
    }

    public IntArith(Network network, int n, Variable variable, Variable variable2, int n2) {
        this(network, n, variable, variable2, (Variable)new IntVariable(network, n2));
    }

    public IntArith(Network network, int n, Variable variable, int n2, Variable variable2) {
        this(network, n, variable, (Variable)new IntVariable(network, n2), variable2);
    }

    public IntArith(Network network, int n, int n2, Variable variable, Variable variable2) {
        this(network, n, (Variable)new IntVariable(network, n2), variable, variable2);
    }

    private IntArith(Network network, int n, Variable[] variableArray) {
        super(network);
        this.operation = n;
        this.v = variableArray;
    }

    @Override
    public Constraint copy(Network network) {
        return new IntArith(network, this.operation, Constraint.copy(this.v, network));
    }

    @Override
    public boolean isModified() {
        return IntArith.isModified(this.v);
    }

    private boolean satisfyADD(Variable variable, Variable variable2, Variable variable3, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        IntDomain intDomain3 = (IntDomain)variable3.getDomain();
        if (intDomain2.size() == 1 && intDomain3.size() == 1) {
            int n = intDomain2.value() + intDomain3.value();
            if (!intDomain.contains(n)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if (intDomain.size() == 1 && intDomain3.size() == 1) {
            int n = intDomain.value() - intDomain3.value();
            if (!intDomain2.contains(n)) {
                return false;
            }
            if (intDomain2.size() > 1) {
                variable2.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if (intDomain.size() == 1 && intDomain2.size() == 1) {
            int n = intDomain.value() - intDomain2.value();
            if (!intDomain3.contains(n)) {
                return false;
            }
            if (intDomain3.size() > 1) {
                variable3.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if ((intDomain = intDomain.capInterval(intDomain2.min() + intDomain3.min(), intDomain2.max() + intDomain3.max())).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        intDomain2 = intDomain2.capInterval(intDomain.min() - intDomain3.max(), intDomain.max() - intDomain3.min());
        if (intDomain2.isEmpty()) {
            return false;
        }
        variable2.updateDomain(intDomain2, trail);
        intDomain3 = intDomain3.capInterval(intDomain.min() - intDomain2.max(), intDomain.max() - intDomain2.min());
        if (intDomain3.isEmpty()) {
            return false;
        }
        variable3.updateDomain(intDomain3, trail);
        return true;
    }

    private int toInt(long l) {
        return (int)Math.max(-1073741823L, Math.min(0x3FFFFFFFL, l));
    }

    private int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.min(n, nArray[i]);
        }
        return n;
    }

    private int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    private IntDomain multiply(IntDomain intDomain, IntDomain intDomain2, IntDomain intDomain3) {
        if (!intDomain2.contains(0) && !intDomain3.contains(0) && (intDomain = intDomain.delete(0)).isEmpty()) {
            return IntDomain.EMPTY;
        }
        int[] nArray = new int[]{this.toInt((long)intDomain2.min() * (long)intDomain3.min()), this.toInt((long)intDomain2.min() * (long)intDomain3.max()), this.toInt((long)intDomain2.max() * (long)intDomain3.min()), this.toInt((long)intDomain2.max() * (long)intDomain3.max())};
        intDomain = intDomain.capInterval(this.min(nArray), this.max(nArray));
        return intDomain;
    }

    private IntDomain divide(IntDomain intDomain, IntDomain intDomain2, IntDomain intDomain3) {
        if (!intDomain2.contains(0) && (intDomain = intDomain.delete(0)).isEmpty()) {
            return IntDomain.EMPTY;
        }
        if (intDomain3.contains(0)) {
            return intDomain;
        }
        if (intDomain3.max() < 0 || 0 < intDomain3.min()) {
            int[] nArray = new int[]{intDomain2.min() / intDomain3.min(), intDomain2.max() / intDomain3.min(), intDomain2.min() / intDomain3.max(), intDomain2.max() / intDomain3.max()};
            intDomain = intDomain.capInterval(this.min(nArray), this.max(nArray));
        } else {
            int[] nArray = new int[]{intDomain2.min() / intDomain3.min(), intDomain2.max() / intDomain3.min(), intDomain2.min() / intDomain3.max(), intDomain2.max() / intDomain3.max(), intDomain2.min(), intDomain2.max(), -intDomain2.min(), -intDomain2.max()};
            intDomain = intDomain.capInterval(this.min(nArray), this.max(nArray));
        }
        return intDomain;
    }

    private boolean satisfyMULTIPLY(Variable variable, Variable variable2, Variable variable3, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        IntDomain intDomain3 = (IntDomain)variable3.getDomain();
        if (intDomain2.size() == 1 && intDomain3.size() == 1) {
            int n = this.toInt((long)intDomain2.value() * (long)intDomain3.value());
            if (!intDomain.contains(n)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if (intDomain.size() == 1 && intDomain3.size() == 1) {
            int n = intDomain.value();
            int n2 = intDomain3.value();
            if (n2 == 0) {
                return n == 0;
            }
            if (n % n2 != 0) {
                return false;
            }
            int n3 = n / n2;
            if (!intDomain2.contains(n3)) {
                return false;
            }
            if (intDomain2.size() > 1) {
                variable2.updateDomain(new IntDomain(n3), trail);
            }
            return true;
        }
        if (intDomain.size() == 1 && intDomain2.size() == 1) {
            int n = intDomain.value();
            int n4 = intDomain2.value();
            if (n4 == 0) {
                return n == 0;
            }
            if (n % n4 != 0) {
                return false;
            }
            int n5 = n / n4;
            if (!intDomain3.contains(n5)) {
                return false;
            }
            if (intDomain3.size() > 1) {
                variable3.updateDomain(new IntDomain(n5), trail);
            }
            return true;
        }
        if ((intDomain = this.multiply(intDomain, intDomain2, intDomain3)).isEmpty()) {
            return false;
        }
        if ((intDomain2 = this.divide(intDomain2, intDomain, intDomain3)).isEmpty()) {
            return false;
        }
        if ((intDomain3 = this.divide(intDomain3, intDomain, intDomain2)).isEmpty()) {
            return false;
        }
        if (intDomain != variable.getDomain()) {
            variable.updateDomain(intDomain, trail);
        }
        if (intDomain2 != variable2.getDomain()) {
            variable2.updateDomain(intDomain2, trail);
        }
        if (intDomain3 != variable3.getDomain()) {
            variable3.updateDomain(intDomain3, trail);
        }
        return true;
    }

    private boolean satisfyMAX(Variable variable, Variable variable2, Variable variable3, Trail trail) {
        int n;
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        IntDomain intDomain3 = (IntDomain)variable3.getDomain();
        if (intDomain2.size() == 1 && intDomain3.size() == 1) {
            int n2 = Math.max(intDomain2.value(), intDomain3.value());
            if (!intDomain.contains(n2)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n2), trail);
            }
            return true;
        }
        if (intDomain.size() == 1) {
            int n3 = intDomain.value();
            if (!intDomain2.contains(n3) && !intDomain3.contains(n3)) {
                return false;
            }
            if (intDomain2.max() > n3) {
                intDomain2.capInterval(-1073741823, n3);
                if (intDomain2.isEmpty()) {
                    return false;
                }
                variable2.updateDomain(intDomain2, trail);
            }
            if (intDomain3.max() > n3) {
                intDomain3.capInterval(-1073741823, n3);
                if (intDomain3.isEmpty()) {
                    return false;
                }
                variable3.updateDomain(intDomain3, trail);
            }
            return true;
        }
        int n4 = Math.max(intDomain2.min(), intDomain3.min());
        if ((intDomain = intDomain.capInterval(n4, n = Math.max(intDomain2.max(), intDomain3.max()))).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        if (intDomain2.max() > intDomain.max()) {
            intDomain2 = intDomain2.capInterval(-1073741823, intDomain.max());
        }
        if (intDomain3.max() > intDomain.max()) {
            intDomain3 = intDomain3.capInterval(-1073741823, intDomain.max());
        }
        if (intDomain2.max() < intDomain.min()) {
            intDomain3 = intDomain = (IntDomain)intDomain.cap(intDomain3);
        }
        if (intDomain3.max() < intDomain.min()) {
            intDomain2 = intDomain = (IntDomain)intDomain.cap(intDomain2);
        }
        if (intDomain.isEmpty()) {
            return false;
        }
        if (intDomain2.isEmpty()) {
            return false;
        }
        if (intDomain3.isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        variable2.updateDomain(intDomain2, trail);
        variable3.updateDomain(intDomain3, trail);
        return true;
    }

    private boolean satisfyMIN(Variable variable, Variable variable2, Variable variable3, Trail trail) {
        int n;
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        IntDomain intDomain3 = (IntDomain)variable3.getDomain();
        if (intDomain2.size() == 1 && intDomain3.size() == 1) {
            int n2 = Math.min(intDomain2.value(), intDomain3.value());
            if (!intDomain.contains(n2)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n2), trail);
            }
            return true;
        }
        if (intDomain.size() == 1) {
            int n3 = intDomain.value();
            if (!intDomain2.contains(n3) && !intDomain3.contains(n3)) {
                return false;
            }
            if (intDomain2.min() < n3) {
                intDomain2.capInterval(n3, 0x3FFFFFFF);
                if (intDomain2.isEmpty()) {
                    return false;
                }
                variable2.updateDomain(intDomain2, trail);
            }
            if (intDomain3.min() < n3) {
                intDomain3.capInterval(n3, 0x3FFFFFFF);
                if (intDomain3.isEmpty()) {
                    return false;
                }
                variable3.updateDomain(intDomain3, trail);
            }
            return true;
        }
        int n4 = Math.min(intDomain2.min(), intDomain3.min());
        if ((intDomain = intDomain.capInterval(n4, n = Math.min(intDomain2.max(), intDomain3.max()))).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        if (intDomain2.min() < intDomain.min()) {
            intDomain2 = intDomain2.capInterval(intDomain.min(), 0x3FFFFFFF);
        }
        if (intDomain3.min() < intDomain.min()) {
            intDomain3 = intDomain3.capInterval(intDomain.min(), 0x3FFFFFFF);
        }
        if (intDomain2.min() > intDomain.max()) {
            intDomain3 = intDomain = (IntDomain)intDomain.cap(intDomain3);
        }
        if (intDomain3.min() > intDomain.max()) {
            intDomain2 = intDomain = (IntDomain)intDomain.cap(intDomain2);
        }
        if (intDomain.isEmpty()) {
            return false;
        }
        if (intDomain2.isEmpty()) {
            return false;
        }
        if (intDomain3.isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        variable2.updateDomain(intDomain2, trail);
        variable3.updateDomain(intDomain3, trail);
        return true;
    }

    @Override
    public boolean satisfy(Trail trail) {
        switch (this.operation) {
            case 0: {
                return this.satisfyADD(this.v[0], this.v[1], this.v[2], trail);
            }
            case 1: {
                return this.satisfyADD(this.v[1], this.v[0], this.v[2], trail);
            }
            case 2: {
                return this.satisfyMULTIPLY(this.v[0], this.v[1], this.v[2], trail);
            }
            case 6: {
                return this.satisfyMAX(this.v[0], this.v[1], this.v[2], trail);
            }
            case 7: {
                return this.satisfyMIN(this.v[0], this.v[1], this.v[2], trail);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("IntArith(");
        switch (this.operation) {
            case 0: {
                stringBuilder.append("ADD");
                break;
            }
            case 1: {
                stringBuilder.append("SUBTRACT");
                break;
            }
            case 2: {
                stringBuilder.append("MULTIPLY");
                break;
            }
            case 6: {
                stringBuilder.append("MAX");
                break;
            }
            case 7: {
                stringBuilder.append("MIN");
            }
        }
        stringBuilder.append(',').append(Constraint.toString(this.v)).append(')');
        return stringBuilder.toString();
    }
}

