/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.IntVariable;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class IntComparison
extends Constraint {
    public static final int LE = 0;
    public static final int LT = 1;
    public static final int GE = 2;
    public static final int GT = 3;
    private int comparison;
    private Variable[] v;

    public IntComparison(Network network, int n, Variable variable, Variable variable2) {
        this(network, n, new Variable[]{variable, variable2});
    }

    public IntComparison(Network network, int n, Variable variable, int n2) {
        this(network, n, variable, (Variable)new IntVariable(network, n2));
    }

    public IntComparison(Network network, int n, int n2, Variable variable) {
        this(network, n, (Variable)new IntVariable(network, n2), variable);
    }

    private IntComparison(Network network, int n, Variable[] variableArray) {
        super(network);
        this.comparison = n;
        this.v = variableArray;
    }

    @Override
    public Constraint copy(Network network) {
        return new IntComparison(network, this.comparison, Constraint.copy(this.v, network));
    }

    @Override
    public boolean isModified() {
        return IntComparison.isModified(this.v);
    }

    private boolean satisfyLE(Variable variable, Variable variable2, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        if ((intDomain = intDomain.capInterval(-1073741823, intDomain2.max())).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        intDomain2 = intDomain2.capInterval(intDomain.min(), 0x3FFFFFFF);
        if (intDomain2.isEmpty()) {
            return false;
        }
        variable2.updateDomain(intDomain2, trail);
        return true;
    }

    private boolean satisfyLT(Variable variable, Variable variable2, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        if ((intDomain = intDomain.capInterval(-1073741823, intDomain2.max() - 1)).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        intDomain2 = intDomain2.capInterval(intDomain.min() + 1, 0x3FFFFFFF);
        if (intDomain2.isEmpty()) {
            return false;
        }
        variable2.updateDomain(intDomain2, trail);
        return true;
    }

    @Override
    public boolean satisfy(Trail trail) {
        switch (this.comparison) {
            case 0: {
                return this.satisfyLE(this.v[0], this.v[1], trail);
            }
            case 1: {
                return this.satisfyLT(this.v[0], this.v[1], trail);
            }
            case 2: {
                return this.satisfyLE(this.v[1], this.v[0], trail);
            }
            case 3: {
                return this.satisfyLT(this.v[1], this.v[0], trail);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("IntComparison(");
        switch (this.comparison) {
            case 0: {
                stringBuilder.append("LE");
                break;
            }
            case 1: {
                stringBuilder.append("LT");
                break;
            }
            case 2: {
                stringBuilder.append("GE");
                break;
            }
            case 3: {
                stringBuilder.append("GT");
            }
        }
        stringBuilder.append(',').append(Constraint.toString(this.v)).append(')');
        return stringBuilder.toString();
    }
}

