/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.ac.kobe_u.cs.cream.Domain;

public class IntDomain
extends Domain {
    public static final int MIN_VALUE = -1073741823;
    public static final int MAX_VALUE = 0x3FFFFFFF;
    public static IntDomain EMPTY = new IntDomain();
    public static IntDomain FULL = new IntDomain(-1073741823, 0x3FFFFFFF);
    private ArrayList<int[]> intervals = new ArrayList();
    private int min;
    private int max;

    public IntDomain() {
    }

    public IntDomain(int n) {
        this(n, n);
    }

    public IntDomain(int n, int n2) {
        n = Math.max(n, -1073741823);
        n2 = Math.min(n2, 0x3FFFFFFF);
        if (n <= n2) {
            int[] nArray = new int[]{n, n2};
            this.intervals.add(nArray);
            this.size = n2 - n + 1;
            this.min = n;
            this.max = n2;
        }
    }

    private void updateSize() {
        this.size = 0;
        try {
            for (int[] nArray : this.intervals) {
                this.size += nArray[1] - nArray[0] + 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void updateMinMax() {
        if (this.size > 0) {
            try {
                int[] nArray = this.intervals.get(0);
                this.min = nArray[0];
                nArray = this.intervals.get(this.intervals.size() - 1);
                this.max = nArray[1];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean equals(Domain domain) {
        if (this == domain) {
            return true;
        }
        if (!(domain instanceof IntDomain)) {
            return false;
        }
        IntDomain intDomain = (IntDomain)domain;
        if (this.intervals.size() != intDomain.intervals.size()) {
            return false;
        }
        try {
            for (int i = 0; i < this.intervals.size(); ++i) {
                int[] nArray;
                int[] nArray2 = this.intervals.get(i);
                if (nArray2[0] == (nArray = intDomain.intervals.get(i))[0] && nArray2[1] == nArray[1]) continue;
                return false;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public Object clone() {
        IntDomain intDomain = new IntDomain();
        try {
            for (int[] nArray : this.intervals) {
                intDomain.intervals.add((int[])nArray.clone());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        intDomain.size = this.size;
        intDomain.min = this.min;
        intDomain.max = this.max;
        return intDomain;
    }

    @Override
    public Iterator<Domain> elements() {
        Iterator<Domain> iterator = new Iterator<Domain>(){
            private int choice;
            {
                this.choice = IntDomain.this.min;
            }

            @Override
            public boolean hasNext() {
                if (IntDomain.this.size == 0) {
                    return false;
                }
                while (this.choice <= IntDomain.this.max) {
                    if (IntDomain.this.contains(this.choice)) {
                        return true;
                    }
                    ++this.choice;
                }
                return false;
            }

            @Override
            public Domain next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntDomain intDomain = new IntDomain(this.choice);
                ++this.choice;
                return intDomain;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    public int min() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    public int max() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.max;
    }

    public int value() throws NoSuchElementException {
        if (this.size != 1) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    @Override
    public Object element() throws NoSuchElementException {
        return new Integer(this.value());
    }

    private int indexOf(int n) {
        if (n < this.min || this.max < n) {
            return -1;
        }
        try {
            for (int i = 0; i < this.intervals.size(); ++i) {
                int[] nArray = this.intervals.get(i);
                if (n < nArray[0]) {
                    return -1;
                }
                if (n > nArray[1]) continue;
                return i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Number)) {
            return false;
        }
        return this.contains(((Number)object).intValue());
    }

    public int randomElement() {
        int n = (int)(Math.random() * (double)this.size);
        for (int[] nArray : this.intervals) {
            int n2 = nArray[1] - nArray[0] + 1;
            if (n < n2) {
                return nArray[0] + n;
            }
            n -= n2;
        }
        return this.min();
    }

    @Override
    public Domain insert(Object object) {
        System.out.println("insert: not implemented");
        return this;
    }

    public void remove(int n) {
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            return;
        }
        try {
            int[] nArray = this.intervals.get(n2);
            int n3 = nArray[0];
            int n4 = nArray[1];
            if (n == n3 && n == n4) {
                this.intervals.remove(n2);
            } else if (n == n3) {
                nArray[0] = n3 + 1;
            } else if (n == n4) {
                nArray[1] = n4 - 1;
            } else {
                nArray[0] = n + 1;
                this.intervals.add(n2, new int[]{n3, n - 1});
            }
            --this.size;
            this.updateMinMax();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void remove(Object object) {
        if (!(object instanceof Number)) {
            return;
        }
        this.remove(((Number)object).intValue());
    }

    public IntDomain delete(int n) {
        if (!this.contains(n)) {
            return this;
        }
        IntDomain intDomain = (IntDomain)this.clone();
        intDomain.remove(n);
        return intDomain;
    }

    @Override
    public Domain delete(Object object) {
        if (!(object instanceof Number)) {
            return this;
        }
        return this.delete(((Number)object).intValue());
    }

    public IntDomain delete(int n, int n2) {
        if (this.size == 0 || n > n2 || n2 < this.min || this.max < n) {
            return this;
        }
        if (n == n2) {
            return this.delete(n);
        }
        IntDomain intDomain = new IntDomain();
        try {
            for (int i = 0; i < this.intervals.size(); ++i) {
                int[] nArray;
                int n3;
                int[] nArray2 = this.intervals.get(i);
                int n4 = Math.max(n, nArray2[0]);
                if (n4 <= (n3 = Math.min(n2, nArray2[1]))) {
                    if (nArray2[0] < n4) {
                        nArray = new int[]{nArray2[0], n4 - 1};
                        intDomain.intervals.add(nArray);
                    }
                    if (n3 >= nArray2[1]) continue;
                    nArray = new int[]{n3 + 1, nArray2[1]};
                    intDomain.intervals.add(nArray);
                    continue;
                }
                nArray = new int[]{nArray2[0], nArray2[1]};
                intDomain.intervals.add(nArray);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        intDomain.updateSize();
        intDomain.updateMinMax();
        return intDomain;
    }

    @Override
    public Domain cap(Domain domain) {
        if (!(domain instanceof IntDomain)) {
            return EMPTY;
        }
        IntDomain intDomain = new IntDomain();
        IntDomain intDomain2 = this;
        IntDomain intDomain3 = (IntDomain)domain;
        try {
            int n = 0;
            int n2 = 0;
            while (n < intDomain2.intervals.size() && n2 < intDomain3.intervals.size()) {
                int[] nArray = intDomain2.intervals.get(n);
                int n3 = nArray[0];
                int n4 = nArray[1];
                nArray = intDomain3.intervals.get(n2);
                int n5 = nArray[0];
                int n6 = nArray[1];
                if (n4 < n5) {
                    ++n;
                    continue;
                }
                if (n6 < n3) {
                    ++n2;
                    continue;
                }
                nArray = new int[]{Math.max(n3, n5), Math.min(n4, n6)};
                intDomain.intervals.add(nArray);
                if (n4 <= n6) {
                    ++n;
                }
                if (n6 > n4) continue;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        intDomain.updateSize();
        intDomain.updateMinMax();
        if (intDomain.isEmpty()) {
            return EMPTY;
        }
        return intDomain;
    }

    @Override
    public Domain cup(Domain domain) {
        System.out.println("cup: not implemented");
        return this;
    }

    @Override
    public Domain difference(Domain domain) {
        System.out.println("difference: not implemented");
        return this;
    }

    public IntDomain capInterval(int n, int n2) {
        IntDomain intDomain = this;
        if (-1073741823 < n) {
            intDomain = intDomain.delete(-1073741823, n - 1);
        }
        if (n2 < 0x3FFFFFFF) {
            intDomain = intDomain.delete(n2 + 1, 0x3FFFFFFF);
        }
        return intDomain;
    }

    private String toString(int n) {
        if (n == -1073741823) {
            return "min";
        }
        if (n == 0x3FFFFFFF) {
            return "max";
        }
        return Integer.toString(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        try {
            for (int[] nArray : this.intervals) {
                stringBuilder.append(string).append(this.toString(nArray[0]));
                if (nArray[0] < nArray[1]) {
                    stringBuilder.append("..").append(this.toString(nArray[1]));
                }
                string = ",";
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.size() == 1) {
            return stringBuilder.toString();
        }
        stringBuilder.insert(0, '{').append('}');
        return stringBuilder.toString();
    }
}

