/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.IntVariable;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class IntFunc
extends Constraint {
    public static final int NEGATE = 0;
    public static final int ABS = 1;
    public static final int SIGN = 2;
    private int func;
    private Variable[] v;

    public IntFunc(Network network, int n, Variable variable, Variable variable2) {
        this(network, n, new Variable[]{variable, variable2});
    }

    public IntFunc(Network network, int n, Variable variable, int n2) {
        this(network, n, variable, (Variable)new IntVariable(network, n2));
    }

    public IntFunc(Network network, int n, int n2, Variable variable) {
        this(network, n, (Variable)new IntVariable(network, n2), variable);
    }

    private IntFunc(Network network, int n, Variable[] variableArray) {
        super(network);
        this.func = n;
        this.v = variableArray;
    }

    @Override
    public Constraint copy(Network network) {
        return new IntFunc(network, this.func, Constraint.copy(this.v, network));
    }

    @Override
    public boolean isModified() {
        return IntFunc.isModified(this.v);
    }

    private boolean satisfyNEGATE(Variable variable, Variable variable2, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        if (intDomain2.size() == 1) {
            int n = -intDomain2.value();
            if (!intDomain.contains(n)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if (intDomain.size() == 1) {
            int n = -intDomain.value();
            if (!intDomain2.contains(n)) {
                return false;
            }
            if (intDomain2.size() > 1) {
                variable2.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if ((intDomain = intDomain.capInterval(-intDomain2.max(), -intDomain2.min())).isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        intDomain2 = intDomain2.capInterval(-intDomain.max(), -intDomain.min());
        if (intDomain2.isEmpty()) {
            return false;
        }
        variable2.updateDomain(intDomain2, trail);
        return true;
    }

    private boolean satisfyABS(Variable variable, Variable variable2, Trail trail) {
        int n;
        int n2;
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        if (intDomain2.size() == 1) {
            int n3 = Math.abs(intDomain2.value());
            if (!intDomain.contains(n3)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n3), trail);
            }
            return true;
        }
        if (intDomain.size() == 1) {
            int n4 = intDomain.value();
            if (n4 < 0) {
                return false;
            }
            if (n4 == 0) {
                if (!intDomain2.contains(n4)) {
                    return false;
                }
                if (intDomain2.size() > 1) {
                    variable2.updateDomain(new IntDomain(n4), trail);
                }
                return true;
            }
            if (intDomain2.contains(n4) && intDomain2.contains(-n4)) {
                if (intDomain2.size() > 2) {
                    n4 = Math.abs(n4);
                    intDomain2 = new IntDomain(-n4, n4);
                    intDomain2 = intDomain2.delete(-n4 + 1, n4 - 1);
                    variable2.updateDomain(intDomain2, trail);
                }
                return true;
            }
            if (intDomain2.contains(n4)) {
                if (intDomain2.size() > 1) {
                    variable2.updateDomain(new IntDomain(n4), trail);
                }
                return true;
            }
            if (intDomain2.contains(-n4)) {
                if (intDomain2.size() > 1) {
                    variable2.updateDomain(new IntDomain(-n4), trail);
                }
                return true;
            }
            return false;
        }
        if (intDomain2.min() >= 0) {
            n2 = intDomain2.min();
            n = intDomain2.max();
        } else if (intDomain2.max() <= 0) {
            n2 = -intDomain2.max();
            n = -intDomain2.min();
        } else {
            n2 = 0;
            n = Math.max(-intDomain2.min(), intDomain2.max());
        }
        intDomain = intDomain.capInterval(n2, n);
        if (intDomain.isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        n2 = intDomain.min();
        n = intDomain.max();
        intDomain2 = intDomain2.capInterval(-n, n);
        if (intDomain2.isEmpty()) {
            return false;
        }
        if (n2 > 0) {
            intDomain2 = intDomain2.delete(-n2 + 1, n2 - 1);
        }
        variable2.updateDomain(intDomain2, trail);
        return true;
    }

    private boolean satisfySIGN(Variable variable, Variable variable2, Trail trail) {
        IntDomain intDomain = (IntDomain)variable.getDomain();
        IntDomain intDomain2 = (IntDomain)variable2.getDomain();
        if (intDomain2.size() == 1) {
            int n = 0;
            if (intDomain2.value() < 0) {
                n = -1;
            } else if (intDomain2.value() > 0) {
                n = 1;
            }
            if (!intDomain.contains(n)) {
                return false;
            }
            if (intDomain.size() > 1) {
                variable.updateDomain(new IntDomain(n), trail);
            }
            return true;
        }
        if (intDomain.size() == 1) {
            int n = intDomain.value();
            if (n < 0) {
                if (intDomain2.max() >= 0) {
                    if ((intDomain2 = intDomain2.capInterval(-1073741823, -1)).isEmpty()) {
                        return false;
                    }
                    variable2.updateDomain(intDomain2, trail);
                }
                return true;
            }
            if (n == 0) {
                if (!intDomain2.contains(0)) {
                    return false;
                }
                if (intDomain2.size() > 1) {
                    variable2.updateDomain(new IntDomain(0), trail);
                }
                return true;
            }
            if (n > 0) {
                if (intDomain2.min() <= 0) {
                    if ((intDomain2 = intDomain2.capInterval(1, 0x3FFFFFFF)).isEmpty()) {
                        return false;
                    }
                    variable2.updateDomain(intDomain2, trail);
                }
                return true;
            }
            return false;
        }
        if (-1 > intDomain.min() || intDomain.max() > 1) {
            intDomain = intDomain.capInterval(-1, 1);
        }
        if (intDomain2.min() >= 0) {
            intDomain = intDomain.delete(-1);
        }
        if (!intDomain2.contains(0)) {
            intDomain = intDomain.delete(0);
        }
        if (intDomain2.max() <= 0) {
            intDomain = intDomain.delete(1);
        }
        if (!intDomain.contains(-1) && intDomain2.min() < 0) {
            intDomain2 = intDomain2.capInterval(0, 0x3FFFFFFF);
        }
        if (!intDomain.contains(0)) {
            intDomain2 = intDomain2.delete(0);
        }
        if (!intDomain.contains(1) && intDomain2.max() > 0) {
            intDomain2 = intDomain2.capInterval(-1073741823, 0);
        }
        if (intDomain.isEmpty()) {
            return false;
        }
        if (intDomain2.isEmpty()) {
            return false;
        }
        variable.updateDomain(intDomain, trail);
        variable2.updateDomain(intDomain2, trail);
        return true;
    }

    @Override
    public boolean satisfy(Trail trail) {
        switch (this.func) {
            case 0: {
                return this.satisfyNEGATE(this.v[0], this.v[1], trail);
            }
            case 1: {
                return this.satisfyABS(this.v[0], this.v[1], trail);
            }
            case 2: {
                return this.satisfySIGN(this.v[0], this.v[1], trail);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String string = "";
        switch (this.func) {
            case 0: {
                string = "NEGATE";
                break;
            }
            case 1: {
                string = "ABS";
                break;
            }
            case 2: {
                string = "SIGN";
            }
        }
        return "IntFunc(" + string + "," + Constraint.toString(this.v) + ")";
    }
}

