/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.List;
import jp.ac.kobe_u.cs.cream.Code;
import jp.ac.kobe_u.cs.cream.DefaultSolver;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Operation;
import jp.ac.kobe_u.cs.cream.Solution;
import jp.ac.kobe_u.cs.cream.Solver;

public class LocalSearch
extends Solver {
    public long initialTimeout = 0L;
    public long iterationTimeout = 5000L;
    public DefaultSolver solver = null;
    private int iterations = 0;
    private boolean newCandidate = false;
    private Solution candidate = null;
    private double exchangeRate = 0.05;

    public LocalSearch(Network network) {
        this(network, -1, null);
    }

    public LocalSearch(Network network, int n) {
        this(network, n, null);
    }

    public LocalSearch(Network network, String string) {
        this(network, -1, string);
    }

    public LocalSearch(Network network, int n, String string) {
        super(network, n, string);
        this.solver = new DefaultSolver(network, n);
    }

    public int getIterations() {
        return this.iterations;
    }

    public synchronized Solution getCandidate() {
        if (this.newCandidate) {
            this.newCandidate = false;
            return this.candidate;
        }
        if (this.solution != null) {
            return this.solution;
        }
        return this.bestSolution;
    }

    public synchronized void setCandidate(Solution solution) {
        if (solution != null) {
            this.candidate = solution;
            this.newCandidate = true;
        }
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(double d) {
        this.exchangeRate = d;
    }

    @Override
    public synchronized void stop() {
        if (this.solver != null) {
            this.solver.stop();
        }
        super.stop();
    }

    public void startSearch() {
        this.solution = this.solver.findFirst(this.initialTimeout);
    }

    public void nextSearch() {
        this.solution = this.getCandidate();
        if (this.solution == null) {
            return;
        }
        Code code = this.solution.getCode();
        List<Operation> list = code.operations();
        while (list.size() > 0) {
            int n = (int)((double)list.size() * Math.random());
            Operation operation = list.remove(n);
            code.setTo(this.network);
            operation.applyTo(this.network);
            Solution solution = this.solver.findBest(this.iterationTimeout);
            if (solution == null) continue;
            this.solution = solution;
            return;
        }
        this.solution = null;
    }

    public void endSearch() {
        this.solver = null;
    }

    @Override
    public void run() {
        this.iterations = 0;
        this.clearBest();
        this.startSearch();
        while (!this.isAborted() && this.solution != null) {
            ++this.iterations;
            this.success();
            if (this.isAborted()) break;
            this.nextSearch();
            if (this.isAborted()) break;
            if (this.solution != null) continue;
            this.solution = this.bestSolution;
        }
        this.fail();
        this.endSearch();
    }
}

