/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import jp.ac.kobe_u.cs.cream.Solver;

public class Monitor
extends Frame {
    private static final long serialVersionUID = 2455481861250231140L;
    private long startTime;
    private ArrayList<Solver> solvers;
    private IdentityHashMap<Solver, Integer[]> solverData;
    private int current_x;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private Image image = null;
    private long prevPaintTime;
    public int topMargin = 100;
    public int botMargin = 50;
    public int leftMargin = 50;
    public int rightMargin = 50;
    private double xscale;
    private double yscale;
    private Color[] colors = new Color[]{Color.RED, Color.BLUE, new Color(0, 128, 0), new Color(0, 128, 128), Color.MAGENTA, Color.GREEN, new Color(128, 128, 0), Color.PINK};

    public Monitor() {
        this.init();
        this.setSize(800, 600);
        this.setResizable(true);
        MenuItem menuItem = new MenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Monitor.this.dispose();
            }
        });
        MenuItem menuItem2 = new MenuItem("Quit");
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        Menu menu = new Menu("Window");
        menu.add(menuItem);
        menu.add(menuItem2);
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.setBackground(Color.WHITE);
        this.validate();
        this.setVisible(true);
    }

    public synchronized void init() {
        this.startTime = System.currentTimeMillis();
        this.solvers = new ArrayList();
        this.solverData = new IdentityHashMap();
        this.current_x = 0;
        this.setX(0, 10);
        this.ymin = Integer.MAX_VALUE;
        this.ymax = Integer.MIN_VALUE;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public synchronized void setX(int n, int n2) {
        this.xmin = Math.max(0, n);
        this.xmax = Math.max(this.xmin + 60, n2);
    }

    public synchronized void add(Solver solver) {
        this.solvers.add(solver);
    }

    public synchronized void addData(Solver solver, int n) {
        long l = System.currentTimeMillis();
        int n2 = (int)((l - this.startTime) / 1000L);
        int n3 = n2 - this.xmin;
        if (n2 < this.xmin) {
            return;
        }
        if (n2 > this.xmax) {
            this.xmax = this.xmin + 4 * n3 / 3;
            if (this.xmax % 60 != 0) {
                this.xmax += 60 - this.xmax % 60;
            }
        }
        this.current_x = Math.max(this.current_x, n2);
        this.ymin = Math.min(this.ymin, n);
        this.ymax = Math.max(this.ymax, n);
        Integer[] integerArray = this.solverData.get(solver);
        if (integerArray == null) {
            integerArray = new Integer[this.xmax - this.xmin];
            this.solverData.put(solver, integerArray);
        }
        if (n3 >= integerArray.length) {
            Integer[] integerArray2 = new Integer[4 * n3 / 3];
            System.arraycopy(integerArray, 0, integerArray2, 0, integerArray.length);
            integerArray = integerArray2;
            this.solverData.put(solver, integerArray);
        }
        integerArray[n3] = new Integer(n);
        if (this.image == null || l - this.prevPaintTime >= 1000L) {
            this.repaint();
            this.prevPaintTime = l;
        }
    }

    private int wpos(int n) {
        return this.leftMargin + (int)(this.xscale * (double)(n - this.xmin));
    }

    private int hpos(int n) {
        return this.topMargin + (int)(this.yscale * (double)(this.ymax - n));
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(this.wpos(n), this.hpos(n2), this.wpos(n3), this.hpos(n4));
    }

    private synchronized void updateImage(int n, int n2) {
        this.image = this.createImage(n, n2);
        int n3 = n - (this.leftMargin + this.rightMargin);
        int n4 = n2 - (this.topMargin + this.botMargin);
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.xmin >= this.xmax || this.ymin >= this.ymax) {
            return;
        }
        this.xscale = (double)n3 / (double)(this.xmax - this.xmin);
        this.yscale = (double)n4 / (double)(this.ymax - this.ymin);
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(Color.LIGHT_GRAY);
        this.drawLine(graphics, this.xmin, this.ymin, this.xmax, this.ymin);
        this.drawLine(graphics, this.xmin, this.ymax, this.xmax, this.ymax);
        graphics.setColor(Color.BLACK);
        graphics.drawString(Integer.toString(this.xmax), this.wpos(this.xmax), this.hpos(this.ymin) + this.botMargin / 4);
        this.drawLine(graphics, this.xmin, this.ymin, this.xmin, this.ymax);
        graphics.drawString(Integer.toString(this.ymin), this.leftMargin / 3, this.hpos(this.ymin) + 5);
        graphics.drawString(Integer.toString(this.ymax), this.leftMargin / 3, this.hpos(this.ymax) + 5);
        graphics.drawString("time=" + this.current_x, this.wpos(this.xmin), this.hpos(this.ymin) + this.botMargin / 2);
        for (int i = 0; i < this.solvers.size(); ++i) {
            Solver solver = this.solvers.get(i);
            Integer[] integerArray = this.solverData.get(solver);
            if (integerArray == null) continue;
            graphics.setColor(this.colors[i % this.colors.length]);
            String string = solver.toString() + "=" + solver.getBestValue();
            graphics.drawString(string, this.wpos(this.xmin) + 100 * (i + 1), this.hpos(this.ymin) + this.botMargin / 2);
            int n5 = -1;
            int n6 = -1;
            for (int j = 0; j < integerArray.length; ++j) {
                if (integerArray[j] == null) continue;
                int n7 = this.xmin + j;
                int n8 = integerArray[j];
                if (n5 >= 0) {
                    this.drawLine(graphics, n5, n6, n7, n8);
                }
                n5 = n7;
                n6 = n8;
            }
        }
    }

    @Override
    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.updateImage(dimension.width, dimension.height);
        graphics.drawImage(this.image, 0, 0, null);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }
}

