/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.ArrayList;
import java.util.List;
import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.Variable;

public class Network
implements Cloneable {
    private Variable objective = null;
    private List<Variable> variables = new ArrayList<Variable>();
    private List<Constraint> constraints = new ArrayList<Constraint>();

    public void setObjective(Variable variable) {
        this.objective = variable;
        if (variable != null) {
            this.add(variable);
        }
    }

    protected Variable add(Variable variable) throws IllegalArgumentException {
        if (!this.variables.contains(variable)) {
            if (variable.getIndex() >= 0) {
                throw new IllegalArgumentException();
            }
            variable.setIndex(this.variables.size());
            this.variables.add(variable);
        }
        return variable;
    }

    protected Constraint add(Constraint constraint) throws IllegalArgumentException {
        if (!this.constraints.contains(constraint)) {
            if (constraint.getIndex() >= 0) {
                throw new IllegalArgumentException();
            }
            constraint.setIndex(this.constraints.size());
            this.constraints.add(constraint);
        }
        return constraint;
    }

    public Variable getObjective() {
        return this.objective;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public Variable getVariable(int n) {
        return this.getVariables().get(n);
    }

    public Constraint getConstraint(int n) {
        return this.getConstraints().get(n);
    }

    public Object clone() {
        Object object;
        Network network = new Network();
        for (Variable object2 : this.variables) {
            object = object2.copy(network);
            if (object2.getIndex() == ((Variable)object).getIndex()) continue;
            throw new IllegalArgumentException();
        }
        for (Constraint constraint : this.constraints) {
            object = constraint.copy(network);
            if (constraint.getIndex() == ((Constraint)object).getIndex()) continue;
            throw new IllegalArgumentException();
        }
        if (this.objective != null) {
            network.setObjective(network.getVariable(this.objective.getIndex()));
        }
        return network;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        if (this.objective != null) {
            stringBuilder.append("Objective: ").append(this.objective.getName()).append('=').append(this.objective.getDomain()).append('\n');
        }
        for (Variable object : this.variables) {
            stringBuilder.append(object.getName()).append('=').append(object.getDomain()).append('\n');
        }
        for (Constraint constraint : this.constraints) {
            stringBuilder.append(constraint.toString()).append('\n');
        }
        return stringBuilder.toString();
    }
}

