/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.LocalSearch;
import jp.ac.kobe_u.cs.cream.Monitor;
import jp.ac.kobe_u.cs.cream.Solution;
import jp.ac.kobe_u.cs.cream.SolutionHandler;
import jp.ac.kobe_u.cs.cream.Solver;

public class ParallelSolver
extends Solver
implements SolutionHandler {
    private Solver[] solvers;

    public ParallelSolver(Solver[] solverArray) {
        this(solverArray, null);
    }

    public ParallelSolver(Solver[] solverArray, String string) {
        super(null, 0, string);
        this.solvers = solverArray;
        this.network = solverArray[0].network;
        this.option = solverArray[0].option;
    }

    public synchronized Solver[] getSolvers() {
        return this.solvers;
    }

    @Override
    public void setMonitor(Monitor monitor) {
        for (Solver solver : this.solvers) {
            solver.setMonitor(monitor);
        }
    }

    @Override
    public synchronized void stop() {
        for (Solver solver : this.solvers) {
            solver.stop();
        }
        super.stop();
    }

    @Override
    public synchronized void solved(Solver solver, Solution solution) {
        if (this.isAborted() || solution == null) {
            return;
        }
        int n = this.bestValue;
        this.solution = solution;
        this.success();
        if (!(solver instanceof LocalSearch)) {
            return;
        }
        if (this.network.getObjective() == null) {
            return;
        }
        int n2 = solution.getObjectiveIntValue();
        if (!this.isBetter(n2, n)) {
            double d = 0.0;
            if (solver instanceof LocalSearch) {
                d = ((LocalSearch)solver).getExchangeRate();
            }
            if (Math.random() < d) {
                ((LocalSearch)solver).setCandidate(this.bestSolution);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void allStart() {
        Solver[] solverArray = this.solvers;
        int n = solverArray.length;
        for (int i = 0; i < n; ++i) {
            Solver solver;
            Solver solver2 = solver = solverArray[i];
            synchronized (solver2) {
                if (solver != null) {
                    solver.start(this, this.totalTimeout);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void allJoin() {
        Solver[] solverArray = this.solvers;
        int n = solverArray.length;
        for (int i = 0; i < n; ++i) {
            Solver solver;
            Solver solver2 = solver = solverArray[i];
            synchronized (solver2) {
                if (solver != null) {
                    solver.join();
                }
                continue;
            }
        }
    }

    @Override
    public void run() {
        this.clearBest();
        this.allStart();
        this.allJoin();
        this.fail();
    }
}

