/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.List;
import jp.ac.kobe_u.cs.cream.Code;
import jp.ac.kobe_u.cs.cream.LocalSearch;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Operation;
import jp.ac.kobe_u.cs.cream.Solution;

public class SASearch
extends LocalSearch {
    private double gamma = 0.999;
    private double temperature = 100.0;

    public SASearch(Network network) {
        this(network, -1, null);
    }

    public SASearch(Network network, int n) {
        this(network, n, null);
    }

    public SASearch(Network network, String string) {
        this(network, -1, string);
    }

    public SASearch(Network network, int n, String string) {
        super(network, n, string);
        this.setExchangeRate(0.05);
    }

    public synchronized double getGamma() {
        return this.gamma;
    }

    public synchronized void setGamma(double d) {
        this.gamma = d;
    }

    public synchronized double getTemperature() {
        return this.temperature;
    }

    public synchronized void setTemperature(double d) {
        this.temperature = d;
    }

    @Override
    public void startSearch() {
        super.startSearch();
        this.temperature = (double)this.solution.getObjectiveIntValue() / 10.0;
    }

    @Override
    public void nextSearch() {
        if (this.totalTimeout > 0L) {
            long l = Math.max(1L, System.currentTimeMillis() - this.startTime);
            double d = (double)this.getIterations() / (double)l;
            int n = (int)(d * (double)(this.totalTimeout - l));
            if (n > 0) {
                this.gamma = Math.exp(Math.log(1.0 / this.temperature) / (double)n);
                this.gamma = Math.min(0.9999, this.gamma);
            }
        }
        this.temperature *= this.gamma;
        this.solution = this.getCandidate();
        if (this.solution == null) {
            return;
        }
        int n = this.solution.getObjectiveIntValue();
        Code code = this.solution.getCode();
        List<Operation> list = code.operations();
        while (list.size() > 0) {
            int n2 = (int)((double)list.size() * Math.random());
            Operation operation = list.remove(n2);
            code.setTo(this.network);
            operation.applyTo(this.network);
            Solution solution = this.solver.findBest(this.iterationTimeout);
            if (solution == null) continue;
            double d = solution.getObjectiveIntValue() - n;
            if (this.isOption(2)) {
                d = -d;
            }
            if (d < 0.0) {
                this.solution = solution;
                return;
            }
            double d2 = Math.exp(-d / this.temperature);
            if (d2 < Math.random()) continue;
            this.solution = solution;
            return;
        }
        this.solution = null;
    }
}

