/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class Sequential
extends Constraint {
    private Variable[] v;
    private int[] a;

    public Sequential(Network network, Variable[] variableArray, int[] nArray) {
        super(network);
        this.v = (Variable[])variableArray.clone();
        this.a = (int[])nArray.clone();
    }

    @Override
    public Constraint copy(Network network) {
        return new Sequential(network, Constraint.copy(this.v, network), this.a);
    }

    @Override
    public boolean isModified() {
        return Sequential.isModified(this.v);
    }

    @Override
    public boolean satisfy(Trail trail) {
        for (int i = 0; i < this.v.length - 1; ++i) {
            int n = i + 1;
            IntDomain intDomain = (IntDomain)this.v[i].getDomain();
            IntDomain intDomain2 = (IntDomain)this.v[n].getDomain();
            int n2 = intDomain2.max() - this.a[i] + 1;
            int n3 = intDomain.min() + this.a[i] - 1;
            if ((intDomain = intDomain.delete(n2, 0x3FFFFFFF)).isEmpty()) {
                return false;
            }
            if ((intDomain2 = intDomain2.delete(-1073741823, n3)).isEmpty()) {
                return false;
            }
            this.v[i].updateDomain(intDomain, trail);
            this.v[n].updateDomain(intDomain2, trail);
        }
        return true;
    }

    @Override
    public String toString() {
        return "Sequential(" + Constraint.toString(this.v) + "," + Constraint.toString(this.a) + ")";
    }
}

