/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import jp.ac.kobe_u.cs.cream.Condition;
import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.Domain;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Operation;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class Serialized
extends Constraint {
    private Variable[] v;
    private int[] a;
    private int[] order;

    public Serialized(Network network, Variable[] variableArray, int[] nArray) {
        super(network);
        this.v = (Variable[])variableArray.clone();
        this.a = (int[])nArray.clone();
        this.order = null;
    }

    @Override
    public Constraint copy(Network network) {
        return new Serialized(network, Constraint.copy(this.v, network), this.a);
    }

    @Override
    protected void clearCondition() {
        this.order = null;
    }

    @Override
    protected Condition extractCondition() {
        return new SerializedCondition();
    }

    @Override
    public boolean isModified() {
        return Serialized.isModified(this.v);
    }

    private boolean satisfySequential(Trail trail) {
        if (this.order == null) {
            return true;
        }
        for (int i = 0; i < this.order.length - 1; ++i) {
            int n = this.order[i];
            int n2 = this.order[i + 1];
            IntDomain intDomain = (IntDomain)this.v[n].getDomain();
            IntDomain intDomain2 = (IntDomain)this.v[n2].getDomain();
            int n3 = intDomain2.max() - this.a[n] + 1;
            int n4 = intDomain.min() + this.a[n] - 1;
            if ((intDomain = intDomain.delete(n3, 0x3FFFFFFF)).isEmpty()) {
                return false;
            }
            if ((intDomain2 = intDomain2.delete(-1073741823, n4)).isEmpty()) {
                return false;
            }
            this.v[n].updateDomain(intDomain, trail);
            this.v[n2].updateDomain(intDomain2, trail);
        }
        return true;
    }

    private boolean satisfySerialized(Trail trail) {
        for (int i = 0; i < this.v.length; ++i) {
            for (int j = 0; j < this.v.length; ++j) {
                int n;
                if (i == j) continue;
                IntDomain intDomain = (IntDomain)this.v[i].getDomain();
                IntDomain intDomain2 = (IntDomain)this.v[j].getDomain();
                int n2 = intDomain2.max() - this.a[i] + 1;
                if (n2 > (n = intDomain2.min() + this.a[j] - 1)) continue;
                if ((intDomain = intDomain.delete(n2, n)).isEmpty()) {
                    return false;
                }
                this.v[i].updateDomain(intDomain, trail);
            }
        }
        return true;
    }

    @Override
    public boolean satisfy(Trail trail) {
        if (!this.satisfySequential(trail)) {
            return false;
        }
        return this.satisfySerialized(trail);
    }

    @Override
    public String toString() {
        return "Serialized(" + Constraint.toString(this.v) + "," + Constraint.toString(this.a) + ")";
    }

    static /* synthetic */ int[] access$202(Serialized serialized, int[] nArray) {
        serialized.order = nArray;
        return nArray;
    }

    public class Swap
    extends Operation {
        private int index;
        private int i;
        private int j;

        public Swap(int n, int n2, int n3) {
            this.index = n;
            this.i = n2;
            this.j = n3;
        }

        @Override
        public void applyTo(Network network) {
            Serialized serialized = (Serialized)network.getConstraint(this.index);
            int n = serialized.order[this.i];
            ((Serialized)serialized).order[this.i] = serialized.order[this.j];
            ((Serialized)serialized).order[this.j] = n;
        }

        @Override
        public boolean isTaboo(Operation operation) {
            if (!(operation instanceof Swap)) {
                return false;
            }
            Swap swap = (Swap)operation;
            return this.index == swap.index && this.i == swap.i && this.j == swap.j;
        }
    }

    public class SerializedCondition
    extends Condition {
        private int[][] code;

        public SerializedCondition() {
            this.index = Serialized.this.getIndex();
            this.code = new int[Serialized.this.v.length][3];
            for (int i = 0; i < this.code.length; ++i) {
                Domain domain = Serialized.this.v[i].getDomain();
                this.code[i][0] = i;
                this.code[i][1] = ((IntDomain)domain).value();
                this.code[i][2] = Serialized.this.a[i];
            }
            Comparator<int[]> comparator = new Comparator<int[]>(){

                @Override
                public int compare(int[] nArray, int[] nArray2) {
                    int n = nArray[1];
                    int n2 = nArray2[1];
                    return n < n2 ? -1 : (n == n2 ? 0 : 1);
                }
            };
            Arrays.sort(this.code, comparator);
        }

        @Override
        public void setTo(Network network) {
            Serialized serialized = (Serialized)network.getConstraint(this.index);
            if (this.code == null) {
                Serialized.access$202(serialized, null);
            } else {
                Serialized.access$202(serialized, new int[this.code.length]);
                for (int i = 0; i < serialized.order.length; ++i) {
                    ((Serialized)serialized).order[i] = this.code[i][0];
                }
            }
        }

        @Override
        public List<Operation> operations() {
            LinkedList<Operation> linkedList = new LinkedList<Operation>();
            for (int i = 0; i < this.code.length - 1; ++i) {
                if (this.code[i][1] + this.code[i][2] != this.code[i + 1][1]) continue;
                Swap swap = new Swap(this.index, i, i + 1);
                linkedList.add(swap);
            }
            return linkedList;
        }
    }
}

