/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.List;
import jp.ac.kobe_u.cs.cream.Code;
import jp.ac.kobe_u.cs.cream.Domain;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Variable;

public class Solution {
    private Network network;
    private Domain objectiveDomain;
    private Domain[] bindings;
    private Code code;

    public Solution(Network network) {
        this.network = network;
        this.objectiveDomain = null;
        if (network.getObjective() != null) {
            this.objectiveDomain = network.getObjective().getDomain();
        }
        List<Variable> list = network.getVariables();
        this.bindings = new Domain[list.size()];
        for (Variable variable : list) {
            this.bindings[variable.getIndex()] = variable.getDomain();
        }
        this.code = new Code(network);
    }

    public int getObjectiveIntValue() {
        return ((IntDomain)this.objectiveDomain).value();
    }

    public Domain getDomain(Variable variable) {
        return this.bindings[variable.getIndex()];
    }

    public int getIntValue(Variable variable) {
        return ((IntDomain)this.getDomain(variable)).value();
    }

    public Code getCode() {
        return this.code;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Variable variable : this.network.getVariables()) {
            stringBuilder.append(string).append(variable.getName()).append('=').append(this.getDomain(variable));
            string = ",";
        }
        return stringBuilder.toString();
    }
}

