/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Monitor;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Solution;
import jp.ac.kobe_u.cs.cream.SolutionHandler;

public abstract class Solver
implements Runnable {
    public static final int DEFAULT = -1;
    public static final int NONE = 0;
    public static final int MINIMIZE = 1;
    public static final int MAXIMIZE = 2;
    public static final int BETTER = 4;
    private static int idCounter = 0;
    private int id;
    protected Network network;
    protected int option;
    protected String name;
    protected boolean debug = false;
    protected Solution solution = null;
    protected Solution bestSolution = null;
    protected int bestValue;
    private Thread thread = null;
    private boolean abort = false;
    private boolean running = false;
    private boolean ready = false;
    protected long totalTimeout = 0L;
    protected long startTime = 0L;
    protected long count = 0L;
    private Monitor monitor = null;

    public Solver(Network network) {
        this(network, -1, null);
    }

    public Solver(Network network, int n) {
        this(network, n, null);
    }

    public Solver(Network network, String string) {
        this(network, -1, string);
    }

    public Solver(Network network, int n, String string) {
        this.network = network;
        if (n == -1) {
            n = network.getObjective() == null ? 0 : 1;
        }
        this.option = n;
        this.id = idCounter++;
        this.name = string == null ? this.getClass().getName() + this.id : string;
        this.clearBest();
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        monitor.add(this);
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public static void resetIDCounter() {
        idCounter = 0;
    }

    public int getID() {
        return this.id;
    }

    public void clearBest() {
        this.bestSolution = null;
        this.bestValue = this.isOption(1) ? 0x3FFFFFFF : -1073741823;
    }

    public Solution getSolution() {
        return this.solution;
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public int getBestValue() {
        return this.bestValue;
    }

    public int getOption() {
        return this.option;
    }

    protected boolean isOption(int n) {
        return (this.option & n) != 0;
    }

    protected boolean isBetter(int n, int n2) {
        return this.isOption(1) ? n < n2 : n > n2;
    }

    protected boolean updateBest() {
        if (this.solution == null) {
            return false;
        }
        if (this.network.getObjective() == null) {
            this.bestSolution = this.solution;
            return true;
        }
        int n = this.solution.getObjectiveIntValue();
        if (this.isBetter(n, this.bestValue)) {
            this.bestSolution = this.solution;
            this.bestValue = n;
            return true;
        }
        return false;
    }

    public boolean isAborted() {
        return this.abort;
    }

    public synchronized void start() {
        this.start(0L);
    }

    public synchronized void start(long l) {
        this.thread = null;
        if (this.debug) {
            System.out.println(this.name + " start");
        }
        this.startTime = System.currentTimeMillis();
        this.count = 0L;
        this.totalTimeout = l;
        this.abort = false;
        this.running = true;
        this.ready = false;
        this.solution = null;
        this.thread = new Thread(this);
        this.thread.start();
        this.notifyAll();
    }

    public synchronized void start(SolutionHandler solutionHandler) {
        this.start(solutionHandler, 0L);
    }

    public synchronized void start(SolutionHandler solutionHandler, long l) {
        new Thread(new HandlerInvoker(solutionHandler, l)).start();
    }

    public synchronized boolean waitNext() {
        return this.waitNext(0L);
    }

    public synchronized boolean waitNext(long l) {
        if (this.debug) {
            System.out.println(this.name + " waitNext");
        }
        long l2 = Long.MAX_VALUE;
        if (l > 0L) {
            l2 = System.currentTimeMillis() + l;
        }
        if (this.totalTimeout > 0L) {
            l2 = Math.min(l2, this.startTime + this.totalTimeout);
        }
        while (this.running && !this.ready) {
            if (l2 == Long.MAX_VALUE) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            long l3 = l2 - System.currentTimeMillis();
            if (l3 <= 0L) break;
            try {
                this.wait(Math.max(10L, l3));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.running) {
            return false;
        }
        return this.ready;
    }

    public synchronized void resume() {
        if (this.debug) {
            System.out.println(this.name + " resume");
        }
        this.ready = false;
        this.notifyAll();
    }

    public synchronized void join() {
        if (this.debug) {
            System.out.println(this.name + " join");
        }
        while (this.thread == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }

    public synchronized void stop() {
        if (this.debug) {
            System.out.println(this.name + " stop");
        }
        this.abort = true;
        while (this.running) {
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void success() {
        int n;
        if (this.debug) {
            System.out.println(this.name + " success");
        }
        if (this.abort) {
            return;
        }
        ++this.count;
        Thread.yield();
        boolean bl = this.updateBest();
        if (this.isOption(4)) {
            if (this.monitor != null) {
                n = this.solution.getObjectiveIntValue();
                this.monitor.addData(this, n);
            }
            if (!bl) {
                return;
            }
        } else if (this.monitor != null) {
            n = this.solution.getObjectiveIntValue();
            this.monitor.addData(this, n);
        }
        this.ready = true;
        this.notifyAll();
        while (!this.abort && this.ready) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void fail() {
        if (this.debug) {
            System.out.println(this.name + " fail");
        }
        this.solution = null;
        this.running = false;
        this.notifyAll();
    }

    public long getCount() {
        return this.count;
    }

    public long getElapsedTime() {
        long l = System.currentTimeMillis();
        return l - this.startTime;
    }

    @Override
    public abstract void run();

    public synchronized Solution findFirst() {
        return this.findFirst(0L);
    }

    public synchronized Solution findFirst(long l) {
        this.clearBest();
        this.start(l);
        this.waitNext();
        this.stop();
        return this.getBestSolution();
    }

    public synchronized Solution findBest() {
        return this.findBest(0L);
    }

    public synchronized Solution findBest(long l) {
        this.clearBest();
        this.start(l);
        while (this.waitNext()) {
            this.resume();
        }
        this.stop();
        return this.getBestSolution();
    }

    public synchronized void findAll(SolutionHandler solutionHandler) {
        this.findAll(solutionHandler, 0L);
    }

    public synchronized void findAll(SolutionHandler solutionHandler, long l) {
        this.clearBest();
        this.start(solutionHandler, l);
        this.join();
    }

    public String toString() {
        return this.name;
    }

    private class HandlerInvoker
    implements Runnable {
        private SolutionHandler handler;
        private long timeout;

        public HandlerInvoker(SolutionHandler solutionHandler, long l) {
            this.handler = solutionHandler;
            this.timeout = l;
        }

        @Override
        public void run() {
            Solver.this.clearBest();
            Solver.this.start(this.timeout);
            while (Solver.this.waitNext() && !Solver.this.isAborted()) {
                this.handler.solved(Solver.this, Solver.this.solution);
                Solver.this.resume();
            }
            this.handler.solved(Solver.this, null);
            Solver.this.stop();
        }
    }
}

