/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.Iterator;
import jp.ac.kobe_u.cs.cream.Code;
import jp.ac.kobe_u.cs.cream.LocalSearch;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Operation;
import jp.ac.kobe_u.cs.cream.Solution;

public class TabooSearch
extends LocalSearch {
    public int tabooLength = 16;
    private Operation[] taboo = null;
    private int taboo_i;

    public TabooSearch(Network network) {
        this(network, -1, null);
    }

    public TabooSearch(Network network, int n) {
        this(network, n, null);
    }

    public TabooSearch(Network network, String string) {
        this(network, -1, string);
    }

    public TabooSearch(Network network, int n, String string) {
        super(network, n, string);
        this.setExchangeRate(0.8);
    }

    public void clearTaboo() {
        this.taboo = new Operation[this.tabooLength];
        for (int i = 0; i < this.taboo.length; ++i) {
            this.taboo[i] = null;
        }
        this.taboo_i = 0;
    }

    public boolean isTaboo(Operation operation) {
        if (this.taboo == null) {
            return false;
        }
        for (int i = 0; i < this.taboo.length; ++i) {
            if (this.taboo[i] == null || !operation.isTaboo(this.taboo[i])) continue;
            return true;
        }
        return false;
    }

    public void addTaboo(Operation operation) {
        this.taboo[this.taboo_i] = operation;
        this.taboo_i = (this.taboo_i + 1) % this.taboo.length;
    }

    @Override
    public void startSearch() {
        super.startSearch();
        this.clearTaboo();
    }

    @Override
    public void nextSearch() {
        Operation operation = null;
        Solution solution = null;
        int n = 0x3FFFFFFF;
        this.solution = this.getCandidate();
        if (this.solution == null) {
            return;
        }
        Code code = this.solution.getCode();
        while (!this.isAborted()) {
            Iterator<Operation> iterator = code.operations().iterator();
            while (iterator.hasNext() && !this.isAborted()) {
                int n2;
                Operation operation2 = iterator.next();
                if (this.isTaboo(operation2)) continue;
                code.setTo(this.network);
                operation2.applyTo(this.network);
                Solution solution2 = this.solver.findBest(this.iterationTimeout);
                if (solution2 == null || !this.isBetter(n2 = solution2.getObjectiveIntValue(), n)) continue;
                n = n2;
                operation = operation2;
                solution = solution2;
            }
            if (operation != null) break;
            this.clearTaboo();
        }
        if (this.isAborted()) {
            return;
        }
        code.setTo(this.network);
        operation.applyTo(this.network);
        this.solution = solution;
        this.addTaboo(operation);
    }
}

