/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Domain;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;

public class Variable
implements Cloneable {
    private static int count = 1;
    private Network network;
    private int index = -1;
    private Domain domain;
    private String name;
    private boolean modified;
    private boolean watch;

    public Variable(Network network, Domain domain) {
        this(network, domain, null);
    }

    public Variable(Network network, Domain domain, String string) {
        this.network = network;
        this.domain = domain;
        this.modified = true;
        this.watch = false;
        this.name = string == null ? "v" + count++ : string;
        this.network.add(this);
    }

    public Network getNetwork() {
        return this.network;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        if (this.domain == null || !this.domain.equals(domain)) {
            this.domain = domain;
            this.modified = true;
        }
    }

    public void updateDomain(Domain domain, Trail trail) {
        if (this.domain == null || !this.domain.equals(domain)) {
            trail.push(this);
            this.domain = domain;
            this.modified = true;
            if (this.watch) {
                System.out.println(this + " = " + this.domain);
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean bl) {
        this.watch = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected Variable copy(Network network) {
        return new Variable(network, this.domain, this.name);
    }

    public String toString() {
        return this.name;
    }
}

